/*
** ahead Nero - NRG file treating module
**
** Writen by Sakae Tatibana <tatibana@extra.hu>
**
** 2000, 8/3 coding start
*/

#include <string.h>
#include "binary.h"

#define NRG_C
#include "nrg.h"

typedef struct {
	unsigned char mode;
	unsigned char track;
	unsigned char index;
	unsigned char unknown_a;
	unsigned char unknown_b;
	unsigned char mm;
	unsigned char ss;
	unsigned char ff;
}NRG_TOC_ELEMENT;

int open_nrg_file(char *path, DAO_INFO *out);
int is_track_image_nrg(char *path);

static void read_nrg_toc_element(FILE *in, NRG_TOC_ELEMENT *out);
static int bcd_msf_to_lbn(unsigned char mm, unsigned char ss, unsigned char ff);  

int open_nrg_file(char *path, DAO_INFO *out)
{
	int i,n;
	FILE *in;
	
	unsigned char pattern[4];
	NRG_TOC_ELEMENT work;

	static const unsigned char marker[] = {
		0x43, 0x55, 0x45, 0x53,
	};

	in = fopen(path, "rb");
	if(in == NULL){
		return 0;
	}

	out->path = path;
	
	fseek(in, -4, SEEK_END);
	read_be_int32(in, &n);
	fseek(in, n, SEEK_SET);

	fread(pattern, 1, 4, in);
	if(memcmp(pattern, marker, 4)){
		return 0;
	}

	read_be_int32(in, &n);
	n /= 8;

	read_nrg_toc_element(in, &work); /* track - 0, index - 1 */
	read_nrg_toc_element(in, &work); /* track - 1, index - 0 */

	out->num_of_track = n / 2 - 1;

	for(i=0;i<n-2;i++){
		read_nrg_toc_element(in, &work); /* track - 1, index - 0 */
		if(work.index && work.track != 0xAA){
			out->track[i/2].index = i/2;
			strcpy(out->track[i/2].path, path);

			switch(work.mode){
			case 0x01:
				out->track[i/2].type = DAO_TRACK_TYPE_AUDIO;
				break;
			case 0x41:
				out->track[i/2].type = DAO_TRACK_TYPE_MODE1;
				break;
			case 0x61:
				out->track[i/2].type = DAO_TRACK_TYPE_MODE2;
				break;
			default:
				out->track[i/2].type = DAO_TRACK_TYPE_ELSE;
				out->num_of_track = i/2 + 1;
				return 0;
			}

			out->track[i/2].block_size = 2352;

			out->track[i/2].start = bcd_msf_to_lbn(work.mm, work.ss, work.ff);
			out->track[i/2].offset = (out->track[i/2].start) * 2352;
			out->track[i/2].start -= 150;
		}else{
			out->track[i/2].num_of_block = bcd_msf_to_lbn(work.mm, work.ss, work.ff);
			out->track[i/2].num_of_block -= out->track[i/2].start;
			out->track[i/2].num_of_block -= 150;
		}
	}
	fclose(in);
	return 1;
}

extern int is_track_image_nrg(char *path)
{
	int n;
	FILE *in;

	unsigned char pattern[4];

	static const unsigned char marker[] = {
		0x54, 0x49, 0x4E, 0x46,
	};

	in = fopen(path, "rb");
	if(in == NULL){
		return 0;
	}

	fseek(in, -4, SEEK_END);
	read_be_int32(in, &n);
	fseek(in, n, SEEK_SET);

	fread(pattern, 1, 4, in);
	if(memcmp(pattern, marker, 4)){
		fclose(in);
		return 0;
	}

	fclose(in);
	return 1;
}

static void read_nrg_toc_element(FILE *in, NRG_TOC_ELEMENT *out)
{
	out->mode = fgetc(in);
	out->track = fgetc(in);
	out->index = fgetc(in);
	out->unknown_a = fgetc(in);
	out->unknown_b = fgetc(in);
	out->mm = fgetc(in);
	out->ss = fgetc(in);
	out->ff = fgetc(in);
}

static int bcd_msf_to_lbn(unsigned char mm, unsigned char ss, unsigned char ff)
{
	int r;

	r = ((mm >> 4) * 10 + (mm & 0xf)) * 60 * 75;
	r += ((ss >> 4) * 10 + (ss & 0xf)) * 75;
	r += ((ff >> 4) * 10 + (ff & 0xf));

	return r;
}

